#include ".\pythoninclude\Python.h"
#include ".\pythoninclude\structmember.h"
#include "vector3_type.h"
//#include "module.h"



PyMODINIT_FUNC
PyInit_Vector3Object(void) 
{
    PyObject* m;

    if (PyType_Ready(&Vector3ObjectType) < 0)
        return NULL;

    m = PyModule_Create(&Vector3Objectmodule);
    if (m == NULL)
        return NULL;

    Py_INCREF(&Vector3ObjectType);
    PyModule_AddObject(m, "Vector3", (PyObject *)&Vector3ObjectType);
    return m;
}

PyObject *Vector3_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
	Vector3Object *self;
	self = (Vector3Object *)type->tp_alloc(type, 0);
    if (self != NULL) 
	{    
        self->ob_xval = 0.0f;
		self->ob_yval = 0.0f;
		self->ob_yval = 0.0f;
    }

    return (PyObject *)self;
}

void Vector3_dealloc(Vector3Object* self)
{
    Py_TYPE(self)->tp_free((PyObject*)self);
}

int Vector3_init(Vector3Object *self, PyObject *args, PyObject *kwds)
{
    PyObject *tmp;

    static char *kwlist[] = {"x", "y", "z", NULL};

    if (! PyArg_ParseTupleAndKeywords(args, kwds, "|fff", kwlist, 
                                      &self->ob_xval, &self->ob_yval, 
                                      &self->ob_zval))
        return -1; 

    return 0;
}




